<?php include('layout/header.php'); ?>
<?php include('layout/navbar.php'); ?>

<?php

$getKarir = $config->query("SELECT * FROM karir")->rowObject();
?>

<main id="main">
  <!-- ======= Breadcrumbs ======= -->
  <div class="breadcrumbs">
    <div class="page-header d-flex align-items-center" style="background-image: url('');">
      <div class="container position-relative">
        <div class="row d-flex justify-content-center">
          <div class="col-lg-6 text-center">
            <h2>Karir</h2>
            <p>Jangan Lewatkan Informasi Lowongan Pekerjaan dari Kami</p>
          </div>
        </div>
      </div>
    </div>
    <nav>
      <div class="container">
        <ol>
          <li><a href="">Home</a></li>
          <li>Karir</li>
        </ol>
      </div>
    </nav>
  </div><!-- End Breadcrumbs -->

  <!-- ======= Karir Section ======= -->
  <section id="blog" class="blog">
    <div class="container" data-aos="fade-up">

      <div class="row gy-4 posts-list">

        <?php foreach ($getKarir as $key) :
          $descBahasa = 'description_' . $bahasa;
        ?>
          <div class="col-xl-4 col-md-6">
            <article>
              <a href="detail-karir?id=<?= $key->id_karir ?>">
                <div class="post-img">
                  <img src="<?= $key->image ?>" alt="" class="img-fluid">
                </div>

                <p class="post-category"><?= $bahasa == 'indonesia' ? 'Lowongan Pekerjaan' : 'Job Vacancy' ?></p>

                <h1 class="title" style="margin: 0 0 8px 0;"><?= $key->title ?></h1>
                <h2 style="font-size: 14px;"><i class="bi bi-geo-alt"></i>Ciangsana, Kec Gn Putri, Bogor | <?= $key->status == 'open' ? '<i class="bi bi-patch-check"></i> Open' : '<i class="bi bi-patch-minus"></i> Close' ?></h2>

                <div class="d-flex align-items-center">
                  <div class="post-meta">
                    <p>
                      <?= substr($key->$descBahasa, 0, 100) . '....' ?>
                    </p>
                    <p class="post-date">
                      <time datetime="2022-01-01"><?= $bahasa == 'indonesia' ? 'Tayang' : 'Published' ?>: <?= $key->created_date ?></time>
                    </p>
                  </div>
                </div>
              </a>
            </article>
          </div><!-- End karir list item -->
        <?php endforeach ?>
      </div><!-- End blog karir list -->

      <!-- <div class="blog-pagination">
        <ul class="justify-content-center">
          <li><a href="#">1</a></li>
          <li class="active"><a href="#">2</a></li>
          <li><a href="#">3</a></li>
        </ul>
      </div> -->
      <!-- End blkarirog pagination -->

    </div>
  </section><!-- End Karir Section -->
</main>


<?php include('layout/footer.php'); ?>