<?php
include_once '../config/config.php';

// ini_set('error_reporting', E_ALL);
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);

class Apply
{

    public function __construct()
    {
        $this->db  = new Config();
        $this->url_redis          = 'https://redis.kamideveloper.com/domain/indocoll.id/connection_factory/';
        $this->connection_factory =  'conn_apply';
        $this->connection_reply   =  'conn_apply_reply';
    }

    function toJson($response, $code)
    {
        header('Content-Type: application/json');
        http_response_code($code);
        echo json_encode($response);
        die;
    }

    public function post($value)
    {

        return $_POST[$value];
    }

    public function insert_connection($connection_factory = '',$data = array())
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL            => $this->url_redis . $connection_factory,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => http_build_query(['data' => $data])
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        return $response;
    }

    public function watzap_send($phone, $message)
    {
        $dataSending               = array();
        $dataSending["api_key"]    = 'KBMLSKVCWSGPAEQ4';
        $dataSending["number_key"] = 'VsTrDLQRRX6aXZ3u';
        $dataSending["phone_no"]   = $phone;
        $dataSending["message"]    = $message;

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL            => 'https://api.watzap.id/v1/send_message',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => json_encode($dataSending),
            CURLOPT_HTTPHEADER     => array(
                'Content-Type: application/json'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function upload_job($files)
    {
        $payload = [
            'files' => $files
        ];

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL            => 'https://images.indocoll.id/?api=apply-job',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => $payload,
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function proses()
    {
        $fullname = htmlspecialchars($_POST['fullname'] ?? null);
        $email    = htmlspecialchars($_POST['email'] ?? null);
        $phone    = htmlspecialchars($_POST['phone'] ?? null);
        $sumberInformasi = htmlspecialchars($_POST['sumber_informasi'] ?? null);

        if ($fullname == '' && $fullname == null) {
            $response = [
                'code'    => 400,
                'status'  => 'failed',
                'message' => 'Nama Lengkap Tidak Boleh Kosong',
                'meta'    => [
                    'header_status_code' => 400
                ]
            ];

            $this->toJson($response, $response['meta']['header_status_code']);
        }
        
        if ($email == '' && $email == null) {
            $response = [
                'code'    => 400,
                'status'  => 'failed',
                'message' => 'Email Tidak Boleh Kosong',
                'meta'    => [
                    'header_status_code' => 400
                ]
            ];

            $this->toJson($response, $response['meta']['header_status_code']);
        }

        if ($phone == '' && $phone == null) {
            $response = [
                'code'    => 400,
                'status'  => 'failed',
                'message' => 'Phone Tidak Boleh Kosong',
                'meta'    => [
                    'header_status_code' => 400
                ]
            ];

            $this->toJson($response, $response['meta']['header_status_code']);
        }

        if ($sumberInformasi == '' && $sumberInformasi == null) {
            $response = [
                'code'    => 400,
                'status'  => 'failed',
                'message' => 'Sumber Informasi Tidak Boleh Kosong',
                'meta'    => [
                    'header_status_code' => 400
                ]
            ];
        }

        if ($_POST['files'] == 'kosong' && $_POST['files'] == 'undefined') {
            $response = [
                'code'    => 400,
                'status'  => 'failed',
                'message' => 'File Tidak Boleh Kosong',
                'meta'    => [
                    'header_status_code' => 400
                ]
            ];

            $this->toJson($response, $response['meta']['header_status_code']);
        }

        $cfile     = curl_file_create($_FILES['files']['tmp_name'],$_FILES['files']['type'],$_FILES['files']['name']);
        $uploadimg = $this->upload_job($cfile);
        $res       = json_decode($uploadimg, true);
        
        if(is_numeric($_POST['id']) != true) {
            $response = [
                'code'    => 400,
                'status'  => 'failed',
                'message' => 'Data Gagal Di Tambahkan',
                'meta'    => [
                    'header_status_code' => 400
                ]
            ];

            $this->toJson($response, $response['meta']['header_status_code']);
        }

        if ($res['code'] == "200") {
            $payload = [
                'id_karir'         => $this->db->validate_data($_POST['id']),
                'fullname'         => $this->db->validate_data($fullname),
                'email'            => $this->db->validate_data($email),
                'phone'            => $this->db->validate_data($phone),
                'sumber_informasi' => $this->db->validate_data($_POST['sumber_informasi']),
                'files'            => $this->db->validate_data($res['data']),
                'created_date'     => date('Y-m-d H:i:s'),
            ];

            $insert = $this->db->insert('apply_job', $payload);
    
            if ($insert) {
                $response = array(
                    'code'    => 200,
                    'status'  => 'success',
                    'message' => 'Yeay, Berhasil Submit Lamaran Pekerjaan, Mohon menunggu kabar baik dari kami Yaaa :)',
                    'meta'    => [
                        'header_status_code' => 200,
                    ]
                );

                $getJudulArtikel = $this->db->getEachTable('karir','id_karir',$_POST['id'])->rowObject();
                $judul_loker     = $getJudulArtikel[0]->title;

                $phoneNotif = [
                    '62895327120214', /* IT Alwan */
                    '6281314800354', /*  HRD Elsa */
                    // '6281387248783' /* HRD Erick */
                ];
                
                /* Message Broker Notif Whatsapp */
                foreach ($phoneNotif as $key => $pNtf) {
                    $payloadBroker = [
                        'send_phone'       => $pNtf,
                        'judul_loker'      => $judul_loker,
                        'fullname'         => $fullname,
                        'email'            => $email,
                        'phone'            => $phone,
                        'sumber_informasi' => $payload['sumber_informasi'],
                        'files'            => $payload['files'],
                    ];

                    $this->insert_connection($this->connection_factory, $payloadBroker);
                }


                /* buat Reply Pesan Ke Whatsapp Yang Tercantum */
                $this->insert_connection($this->connection_reply, ['fullname' => $fullname,'phone' => $phone]);

            } else {
                $response = array(
                    'code'    => 400,
                    'status'  => 'failed',
                    'message' => 'Gagal Submit Lamaran Pekerjaan',
                    'meta'    => [
                        'header_status_code' => 400,
                    ]
                );
            }
    
            $this->toJson($response, $response['meta']['header_status_code']);
        } else {
            $response = array(
                'code'    => 400,
                'status'  => 'failed',
                'message' => $res['message'],
                'meta'    => [
                    'header_status_code' => 400,
                ]
            );
            $this->toJson($response, $response['meta']['header_status_code']);
        }
    }
    
}

$apply = new Apply();
$apply->proses();
