<?php

include_once '../config/config.php';

// ini_set('error_reporting', E_ALL);
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);

class Artikel
{
    public function __construct()
    {
        $this->db  = new Config();
        $this->url_redis          = 'https://redis.kamideveloper.com/domain/indocoll.id/connection_factory/';
        $this->connection_factory =  'conn_apply';
        $this->connection_reply   =  'conn_apply_reply';
    }
    
    public function toJson($response, $code)
    {
        header('Content-Type: application/json');
        http_response_code($code);
        echo json_encode($response);
        die;
    }

    public function post($value)
    {

        return $_POST[$value];
    }
    
    public function get($value)
    {

        return $_GET[$value];
    }
    
    public function getAllArtikel()
    {
        $page   = 1; //$this->db->secure_numeric($this->get('page')) ?? 1;
        $limit  = 10; //$this->db->secure_numeric($this->get('limit')) ?? 10;
        $offset = ($page - 1) * $limit;  
        
        $resultGet = $this->db->query(
            "select * from artikel order by id_artikel desc limit $limit offset $offset"
        )->rowObject();
        
        $data = array();
        foreach($resultGet as $val) {
            // print_r($val->photo); die;
            $data[] = [
                "id_artikel" => $val->id_artikel,
                "judul"      => $val->judul,
                'teaser'     => substr($val->content, 0, 50),
                'tipe_berita'=> $val->tipe_berita,
                'created_at' => $val->created_at,
                'created_by' => $val->created_by,
                "url_judul"  => $val->url_judul,
                "photo"      => $val->photo
            ];
        }
        
        $response = [
            'code'      => 200,
            "status"    => true,
            "data"      => $data,
            "meta"      => [
                "meta_header" => 200    
            ]
        ];
        // print_r($response['meta']['meta_header']); die;
        $this->toJson($response, $response['meta']['meta_header']); 
        
    }
    
    public function main()
    {
        if($this->get('action') == 'get-artikel') {
            $this->getAllArtikel();
        }
    }
}

$main = new Artikel();
$main->main();

?>