<?php include('layout/header.php'); ?>
<?php include('layout/navbar.php'); ?>

<?php

if(empty($_GET['id'])) {
    $config->redirect404();
    die;
}

$idKarir        = is_numeric($_GET['id']) ? $config->validate_data($_GET['id']) : $config->validate_data($_GET['id']);
$query          = "SELECT * FROM karir where id_karir = $idKarir";
$getKarirDetail = $config->query($query)->rowObject();
// print_r($getKarirDetail);
$descBahasa     = 'description_' . $bahasa;
?>

<main id="main">

  <!-- ======= Detail Karir Section ======= -->
  <section id="portfolio-details" class="portfolio-details">
    <div class="container" data-aos="fade-up">

      <div class="row justify-content-between gy-4 mt-4">
        <div class="col-lg-8">
          <div class="post-img">
             <img src="<?= $getKarirDetail[0]->image ?>" alt="" class="img-fluid">
          </div>
          <div class="portfolio-description">
            <h2><?= $getKarirDetail[0]->title ?></h2>
            <?= $getKarirDetail[0]->$descBahasa ?? "Kosong" ?>

            <div class="card">
              <div class="card-body">
                <div class="card-title mb-3 text-center font-weight-bold">
                  <h3><?= $bahasa == 'indonesia' ? "Formulir Melamar Pekerjaan" : "Form Apply Job" ?></h3>
                </div>
                <div class="row">
                  <div class="col-12 mb-2">
                    <label for="fulname"><?= $bahasa == 'indonesia' ? "Nama Lengkap" : "Fullname" ?> <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="fullname" id="fulname" placeholder="<?= $bahasa == 'indonesia' ? "Masukan Nama Lengkap" : "Enter Fullname" ?>">
                  </div>
                  <!-- email -->
                  <div class="col-12 mb-2">
                    <label for="email"><?= $bahasa == 'indonesia' ? "Email" : "Email" ?> <span class="text-danger">*</span></label>
                    <input type="email" class="form-control" name="email" id="email" placeholder="<?= $bahasa == 'indonesia' ? "Masukan Email" : "Enter Email" ?>">
                  </div>
                  <div class="col-12 mb-2">
                    <label for="phone"><?= $bahasa == 'indonesia' ? "Nomor Telephone" : "Phone Number" ?> <span class="text-danger">*<?= $bahasa == "indonesia" ?  "Pastikan Whatsapp Aktif" : "Make sure WhatsApp is active" ?></span></label>
                    <input type="number" class="form-control" name="phone" id="phone" placeholder="<?= $bahasa == "indonesia" ?  'Masukkan Nomor Telephone : 08953xxxxx' : 'Enter Phone Numner : 08953xxxxx'?>" onkeyup="validateInput()">
                  </div>
                  <div class="col-12 mb-2">
                    <label for="phone"><?= $bahasa == "indonesia" ? "Sumber Informasi" : "Resources" ?> <span class="text-danger">*</span></label>
                    <select name="" class="form-control" id="sumber_informasi">
                      <option value=""># <?= $bahasa == "indonesia" ? "Pilih Sumber Informasi" : "Select Information Source" ?> #</option>
                      <option value="instagram">instagram</option>
                      <option value="facebook">Facebook</option>
                      <option value="lumina">Lumina</option>
                      <option value="olx">OLX</option>
                      <option value="job_fair">Job Fair</option>
                      <option value="teman_kerabat">Teman / Kerabat</option>
                      <option value="source_hani">Source Hani</option>
                      <option value="source_fahri">Source Fahri</option>
                      <option value="other">Other</option>
                    </select>
                  </div>
                  <div class="col-md-12">
                    <label for="">Upload CV/Portofolio <span class="text-danger">*</span> </label>
                    <input type="file" name="files" class="form-control" id="files" accept="application/pdf">
                  </div>
                </div>
              </div>
              <div class="card-footer">
                <button type="submit" class="btn btn-primary" name="submit" id="send_cv"><?= $bahasa == "indonesia" ? "Kirim Lamaran" : "Submit Application" ?></button>
              </div>
            </div>
            <div class="testimonial-item">
              <p>
                <i class="bi bi-quote quote-icon-left"></i>
                <?= $bahas == 'indonesia' ? '
                    Bekerja di indocoll membuat kami merasa senang
                   ' : 'Working at indocoll makes us happy' ?>
                <i class="bi bi-quote quote-icon-right"></i>
              </p>
            </div>
          </div>
        </div>

        <div class="col-lg-3">
          <div class="portfolio-info">
            <h3><?= $bahasa == 'indonesia' ? 'Lowongan Pekerjaan' : 'Job Vacancy' ?></h3>
            <ul>
              <li><strong><?= $bahasa == 'indonesia' ? 'Kategori' : 'Category' ?></strong> <span><?= $getKarirDetail[0]->kategori_pekerjaan ?></span></li>
              <li><strong><?= $bahasa == 'indonesia' ? 'Perusahaan' : 'Company' ?></strong> <span>PT. Indo Kolekektor Nusantara</span></li>
              <li><strong><?= $bahasa == 'indonesia' ? 'Tanggal Publish' : 'Publish Date' ?></strong> <span><?= $getKarirDetail[0]->created_date ?></span></li>
              <li><a href="https://wa.me/<?= $getKarirDetail[0]->phone_number ?>" class="btn-visit align-self-start"><?= $bahasa == 'indonesia' ? 'Whatsapp' : 'Whatsapp' ?></a></li>
            </ul>
          </div>
        </div>

      </div>

    </div>
  </section><!-- End Detail Karir Section -->

</main>

<script>

  function validateNumber(input) {
    if (input.length > 13) {
      return false; 
    }
    return true;
  }

  function validateInput() {
    var input = document.getElementById("phone").value;
    if (!validateNumber(input)) {
      Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: 'Nomor tidak boleh melebihi 13 digit!',
      })
      // console.log("inputan melebihi 16 digit")
    }
  }

  $(document).ready(function() {
    $('#send_cv').click(function() {
      Swal.fire({
        title: "Apakah Data Anda Sudah Benar?",
        showDenyButton: true,
        showCancelButton: true,
        confirmButtonText: "Simpan",
        denyButtonText: `Batal`
      }).then((result) => {
        if (result.isConfirmed) {
          let formData = new FormData();
          formData.append('id', '<?= $idKarir ?>');
          formData.append('fullname', $('#fulname').val());
          formData.append('email', $('#email').val());
          formData.append('phone', $('#phone').val());
          formData.append('sumber_informasi', $('#sumber_informasi').val());
          formData.append('files', $('#files')[0].files[0] == undefined ? 'kosong' : $('#files')[0].files[0]);

          $.ajax({
            url: 'backend/ajax-apply',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            cache: false,
            beforeSend: function() {
              $("#send_cv").prop("disabled", true);
              $("#send_cv").html("Loading ...");
            },
            success: (res) => {
              if (res.code == 200) {
                Swal.fire({
                  title: "Success",
                  text: res.message,
                  icon: "success",
                  button: "OK",
                })

                $("#send_cv").prop("disabled", false);
                $("#send_cv").html("Kirim Lamaran");
                $("#fulname,#email,#phone,#files").val('');
              }
            },
            error: (err) => {
              Swal.fire({
                icon: 'error',
                title: 'Gagal',
                text: err.responseJSON.message,
              })

              $("#send_cv").prop("disabled", false);
              $("#send_cv").html("Kirim Lamaran");
            }
          })
        } else if (result.isDenied) {
          Swal.fire("Batal", "", "info");
        }
      });

    })

  })
</script>


<?php include('layout/footer.php'); ?>